
#include "Navigation.h"
#include "Moody1I2C.h"
//Dustin Soodak


// ***************************************************
// AutoNavigation Plus IR
// ***************************************************




//millis(), micros(), and delay() all use 8 bit timer0 with its interrupt
//C:\Program Files\Arduino\hardware\arduino\cores\arduino\wiring.c:\
//This timer has the lowest priority interrupt of any timer so we have to handle 
//it in any handler that takes more than 1 ms to run.
//Either have to at least make some static (local) variables into global variables in Wiring.c
//so I can update them in navigation handler, or maybe just keep track of
//when the millis() timer0 update handler is called (look at overflow bit) and exit
//navigation handler at this point (and reset its own timer to be called again shortly). 
//
//Problem: if timer2 times out just before timer0, then the AutoNavigationHandler()
//will barely have any time to run at all.
//
//Solutions: 
//1. have millis(), etc., use timer2 instead so it can interrupt the
//AutoNavigationHandler() on timer0 (makes Moody1 navigation code much cleaner)
//2. add an external interrupt handler routine to the existing timer0 handler (frees a timer
//and only 3 lines of code need to be added to an arduino core library file)
//3. sync up timer2 with timer1 so that timer2 interrupt is called just after timer0 (doesn't 
//require any editing of arduino core library files)
//
//choice 3 is preferred though notes on choice 2 are added in case someone wants to make 
//use of the extra timer
//

char TimeToUpdateMillis(void){
  #ifdef TIFR0
  if (TIFR0 & _BV(TOV0))  
    return 1;
  else
    return 0;
  #else
  if (TIFR & _BV(TOV0))
    return 1;
  else
    return 0;
  #endif
}

#define LIGHT_LeftEdge 0
#define LIGHT_RightEdge 1
#define LIGHT_Left 2
#define LIGHT_LeftAmbient 3
#define LIGHT_Right 4
#define LIGHT_RightAmbient 5
#define LIGHT_Back 6
#define LIGHT_BackAmbient 7
int LightLevels[8]={0,0,0,0,0,0,0,0};


//based on int analogRead(uint8_t pin) in wiring_analog.c in "C:\Program Files\Arduino\hardware\arduino\cores\arduino"
/*
//#include "pins_arduino.h"//analogPinToChannel(),analog_reference
int analogReadStart(uint8_t pin)
{
  pin = analogPinToChannel(pin);
  if (pin >= 14) pin -= 14; // allow for channel or pin numbers
  #if defined(ADCSRB) && defined(MUX5)
  // the MUX5 bit of ADCSRB selects whether we're reading from channels
  // 0 to 7 (MUX5 low) or 8 to 15 (MUX5 high).
  ADCSRB = (ADCSRB & ~(1 << MUX5)) | (((pin >> 3) & 0x01) << MUX5);
  #endif  
  // set the analog reference (high two bits of ADMUX) and select the
  // channel (low 4 bits).  this also sets ADLAR (left-adjust result)
  // to 0 (the default).
  #if defined(ADMUX)
  ADMUX = (analog_reference << 6) | (pin & 0x07);
  #endif

  // start the conversion
  sbi(ADCSRA, ADSC);
}
char analogReadDone(void){
  return bit_is_clear(ADCSRA, ADSC);
}
int analogReadFinish(void)
{
  uint8_t low, high;
  
  // we have to read ADCL first; doing so locks both ADCL
  // and ADCH until ADCH is read.  reading ADCL second would
  // cause the results of each conversion to be discarded,
  // as ADCL and ADCH would be locked when it completed.
  low  = ADCL;
  high = ADCH;
  // combine the two bytes
  return (high << 8) | low;
}
*/

#define N_Direction 0x01
#define N_DirectionXYZ 0x02
#define N_Position 0x04
#define N_PositionXY 0x08 //not implementing for a while since would have to program in 3-axis rotations & accelerations.
#define N_DetectEdge 0x10
#define N_DetectBarrier 0x20
#define N_DetectIR 0x40
uint8_t NavigationFunctions=0;

//MsTimer2:
//http://playground.arduino.cc/Main/MsTimer2
//put into C:\Program Files\Arduino\libraries

extern char PauseNavigationInterrupt;//defined below

int AutoNavigationDelay=1;
int AutoNavigationMs=0;
#define ANP_InitGyro 0
#define ANP_Gyro 1
#define ANP_InitAccel 2
#define ANP_Accel 3
char AutoNavigationPhase=ANP_InitGyro;
char AN_n,AN_i;
char AutoNavigationRunning=0;//if in the middle of a sequence of reads
extern int nav_data[3];//defined below
void AutoNavigationHandler(void){
  //int nav_data[3];//Compiler error:  when nav_data[] local, it was not actually reserving space for this since it isn't explicitly set (is set by pointers)
  int32_t AccelPositionNewDat[3]={0,0,0};
  char j;  
  //digitalWrite(Light_Bus_BTN1,0);DDRD|=(1<<7);//PORTD&=~(1<<7);
  if(AutoNavigationMs<AutoNavigationDelay){
    AutoNavigationMs++;
  }
  else{ 
    AutoNavigationMs=1;
    AutoNavigationRunning=1;
  }
  if(AutoNavigationMs==1 || AutoNavigationRunning){
    AutoNavigationMs=1;       
    //interrupts();//so that interrupt 1 (I/O 3 which is _38kHz_Rx) can interrupt this handler. timer0 has lower priority so nothing else should interrupt.
    if(IRReceiving){
      if(IsIRDone()){
        IRReceiving=0; 
        IRActive=0;        
      }
    }
    if(PauseNavigationInterrupt || IRReceiving){//don't do if IRReceiving, otherwise will mess up measured IR intervals  
    }
    else{
      while(AutoNavigationRunning && !TimeToUpdateMillis()){//note: don't have to check if IRReceiving since pin interrupt 1 has higher priority than timer2 interrupts.
        switch(AutoNavigationPhase){
        case ANP_InitGyro:          
          AN_n=GyroBufferSize();
          AN_i=0;
          if(AN_n>=31)
            GyroFifoOverflow=1;
          AutoNavigationPhase=ANP_Gyro; 
          AutoNavigationRunning=1;         
        break;
        case ANP_Gyro:
          if(AN_i<AN_n){
            GyroGetAxes(nav_data);
            //digitalWrite(Light_Bus_BTN1,0);
            for(j=2;j<3;j++){//just z axis      
              GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
              GyroPosition[j]+=(GyroVelocity[j]);
            }        
            AN_i++;
          }
          else{
            AutoNavigationPhase=ANP_InitAccel;//ANP_InitAccel;            
          }
        break;
        case ANP_InitAccel:
          AN_n=AccelBufferSize();
          AN_i=0;
          if(AN_n>=31)
            AccelFifoOverflow=1; 
          AutoNavigationPhase=ANP_Accel;  
        break;
        case ANP_Accel:
          if(AN_i<AN_n){
            
            AccelGetAxes(nav_data);
            
            
            //less efficient but easier to understand:
            //for(j=0;j<2;j++){   //just x and y axis
            //  AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];  
            //  AccelVelocity[j]+=AccelAcceleration[j];        
            //  AccelPosition[j]+=AccelVelocity[j]/400;//so in range and same as velocity
            //}      
            
            //more efficient:
            for(j=0;j<2;j++){   //just x and y axis
              AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];  
              AccelVelocity[j]+=AccelAcceleration[j];        
              AccelPositionNewDat[j]+=AccelVelocity[j];
            }
            if(AN_i==AN_n-1){
              for(j=0;j<2;j++){
                AccelPosition[j]+=AccelPositionNewDat[j]/400;//so in range and same as velocity
              }
            }
            AN_i++;
          }
          else{
            AutoNavigationPhase=ANP_InitGyro;
            AutoNavigationRunning=0;
          }
        break;        
        }//end switch(AutoNavigationPhase)  
        
      }//end while(!TimeToUpdateMillis())
    }//end if(PauseNavigationInterrupt) else   
    
  }//end if(AutoNavigationMs==1 || AutoNavigationRunning)
  //digitalWrite(Light_Bus_BTN1,1);
}//end void AutoNavigationHandler(void)


//
//If you want to use timer2 for something else, it is possible to put this into timer0 interrupt handler:
//
//Above ISR(TIM0_OVF_vect)/ISR(TIMER0_OVF_vect) in wiring.c in C:\Program Files\Arduino\hardware\arduino\cores\arduino: add
//void (*Timer0Handler)(void)=0;//for Moody1
//In ISR(TIM0_OVF_vect)/ISR(TIMER0_OVF_vect): add
//if(Timer0Handler)//for Moody1
//        Timer0Handler();//for Moody1
//Above StartAutoNavigation(): add
//extern void (*Timer0Handler)(void);
//In StartAutoNavigation(): add
//Timer0Handler=AutoNavigationHandler();
//In StartAutoNavigation(): remove
//any erference to MsTimer2, "uint32_t time", and "millis()"
//

#include <MoodyMsTimer2.h>
void AutoNavigationBegin(int Ms){
  uint32_t time;
  PauseNavigationInterrupt=1;
  //uint8_t oldSREG = SREG;
  //noInterrupts();
  //
  NavigationBegin();
  //
  MsTimer2::set(1, AutoNavigationHandler); // 1ms period
  time=millis();
  while(millis()==time);
  MsTimer2::start();//start timer1 just after timer0
  AutoNavigationPhase=0;
  AutoNavigationMs=0;
  AutoNavigationDelay=Ms;
  //SREG = oldSREG;
  PauseNavigationInterrupt=0;
}
void AutoNavigationStop(void){
  MsTimer2::stop(); 
}
void ChangeAutoNavigationInterval(int Ms){
  uint8_t oldSREG = SREG;
  noInterrupts();
  AutoNavigationDelay=Ms;
  SREG = oldSREG;
}



// ***************************************************
// end AutoNavigation Plus IR
// ***************************************************


// ***************************************************
// Navigation
// ***************************************************

char GyroFifoOverflow=0;
int GyroZeroes[3]={0,0,0};
char AccelFifoOverflow=0;
int AccelZeroes[3]={0,0,0};

char PauseNavigationInterrupt=1;
char NavigationOn=0;
int32_t count;

extern volatile char IRReceiving;
int nav_data[3];//made global so compiler doesn't optimize it out of code
void SimpleGyroNavigation(void){
  char n;
  //int nav_data[3];//Compiler error:  when nav_data[] local, it was not actually reserving space for this since it isn't explicitly set (is set by pointers)
  char i,j;
  if(IRReceiving){
    if(IsIRDone())
     IRReceiving=0; 
  }
  if(!PauseNavigationInterrupt && !IRReceiving){
        
    //Get Gyroscope data
    n=GyroBufferSize();
    //if(n>0)
    //digitalWrite(Light_Bus_BTN1,0);
    for(i=0;i<n;i++){
      GyroGetAxes(nav_data);
      //digitalWrite(Light_Bus_BTN1,0);
      for(j=2;j<3;j++){//just z axis      
        GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
        GyroPosition[j]+=(GyroVelocity[j]);
      }      
      
      //digitalWrite(Light_Bus_BTN1,1);
      /*
      for(j=0;j<3;j++){      
        GyroPositionNewDat[j]+=((int32_t)nav_data[j]);
      }
      if(i==n-1){
        for(j=0;j<3;j++){ 
          GyroVelocity[j]=dat[j];
          GyroPosition[j]+=GyroPositionNewDat[j]-GyroZeroes[j]*n;
        }
      }
      */
    }//end for(i=0;i<n;i++)
    //get current rotational velocity for x & y axes
    for(j=0;j<2;j++){
      GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
    }    
   
    //digitalWrite(Light_Bus_BTN1,1);
    if(n>=31)
      GyroFifoOverflow=1;    
  } 
}
int32_t AverGyroVelocity;
void SimpleNavigation(void){//can't be put in interrupt since I2C functions use an interrupt
  char i,j,n,gn,an;
  //int nav_data[3];//Compiler error:  when nav_data[] local, it was not actually reserving space for this since it isn't explicitly set (is set by pointers)
  int32_t AccelPositionNewDat[3]={0,0,0};
  int32_t AccelVelocityNewDat[3]={0,0,0};
  int32_t GyroPositionNewDat[3]={0,0,0};
  AverGyroVelocity=0;
  count++;
  if(IRReceiving){
    if(IsIRDone())
     IRReceiving=0; 
  }
  if(!PauseNavigationInterrupt && !IRReceiving){
        
    //Get Gyroscope data
    gn=GyroBufferSize();
    
    //digitalWrite(Light_Bus_BTN1,0);
    for(i=0;i<gn;i++){
      GyroGetAxes(nav_data);
      //digitalWrite(Light_Bus_BTN1,0);
      for(j=2;j<3;j++){//just z axis      
        GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
        GyroPosition[j]+=(GyroVelocity[j]);
      }
      AverGyroVelocity+=abs(GyroVelocity[2]);
      //digitalWrite(Light_Bus_BTN1,1);
      
      //better but not debugged yet:
      for(j=0;j<3;j++){      
        GyroPositionNewDat[j]+=((int32_t)nav_data[j]);
      }
      if(i==n-1){
        for(j=0;j<3;j++){ 
          GyroVelocity[j]=nav_data[j];
          GyroPosition[j]+=GyroPositionNewDat[j]-GyroZeroes[j]*n;
        }
      }
      
    }
    //get current rotational velocity for x & y axes
    for(j=0;j<2;j++){
      GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
    }
    AverGyroVelocity/=gn;
    //digitalWrite(Light_Bus_BTN1,1);
    if(gn>=31)
      GyroFifoOverflow=1;
    
    //Get Accelerometer data
    an=AccelBufferSize();
    //if(n>0)
    //digitalWrite(Light_Bus_BTN1,0);
    for(i=0;i<an;i++){
      AccelGetAxes(nav_data);
      //digitalWrite(Light_Bus_BTN1,0);
      /*
      //less efficient but easier to understand:
      for(j=0;j<2;j++){   //just x and y axis
        AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];  
        AccelVelocity[j]+=AccelAcceleration[j];        
        AccelPosition[j]+=AccelVelocity[j]/400;//so in range and same as velocity
      }      
      */
      //more efficient:
      for(j=1;j<2;j++){   //just y axis
        AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];  
        //AccelAcceleration[1]+=(10*(AverGyroVelocity))/8;//assuming that it always rotates about the same point (around where wheels are), experimentally putting this in
        AccelVelocity[j]+=AccelAcceleration[j];        
        AccelPositionNewDat[j]+=AccelVelocity[j];//so in range and same as velocity
      }
      if(i==an-1){
        for(j=1;j<2;j++){//just y axis
          AccelPosition[j]+=AccelPositionNewDat[j]/400;
        }
      }      
      /*
      //better but not debugged yet:
      for(j=0;j<2;j++){   
        AccelVelocityNewDat[j]+=((int32_t)nav_data[j]);
        AccelPositionNewDat[j]+=AccelVelocityNewDat[j];        
      }
      if(i==n-1){
        for(j=0;j<3;j++){ 
          AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];
          AccelPosition[j]=AccelPosition[j]+(AccelVelocity[j]+AccelPositionNewDat[j]*n-AccelZeroes[j]*n)/(400*n);
          AccelVelocity[j]=AccelVelocity[j]+AccelVelocityNewDat[j]-n*AccelZeroes[j];
        }
      }*/

      
      
      //digitalWrite(Light_Bus_BTN1,1);
    }//end for(i=0;i<n;i++
     //get current acceleration for x,y, and z axes
    if(an>0){
      for(j=0;j<3;j++){
        AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];
      }
    }
    //digitalWrite(Light_Bus_BTN1,1);
    if(an>=31)
      AccelFifoOverflow=1;
      
      
  }
  
  
}//end NavigationHandler()


void NavigationXY(void){//can't be put in interrupt since I2C functions use an interrupt
  char i,j,n,gn,an;
  //int nav_data[3];//Compiler error:  when nav_data[] local, it was not actually reserving space for this since it isn't explicitly set (is set by pointers)
  int32_t AccelPositionNewDat[3]={0,0,0};
  int32_t AccelVelocityNewDat[3]={0,0,0};
  int32_t GyroPositionNewDat[3]={0,0,0};
  AverGyroVelocity=0;
  count++;
  if(IRReceiving){
    if(IsIRDone())
     IRReceiving=0; 
  }
  if(!PauseNavigationInterrupt && !IRReceiving){
        
    //Get Gyroscope data
    gn=GyroBufferSize();
    
    //digitalWrite(Light_Bus_BTN1,0);
    for(i=0;i<gn;i++){
      GyroGetAxes(nav_data);
      //digitalWrite(Light_Bus_BTN1,0);
      for(j=2;j<3;j++){//just z axis      
        GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
        GyroPosition[j]+=(GyroVelocity[j]);
      }
      AverGyroVelocity+=abs(GyroVelocity[2]);
      //digitalWrite(Light_Bus_BTN1,1);
      
      //better but not debugged yet:
      for(j=0;j<3;j++){      
        GyroPositionNewDat[j]+=((int32_t)nav_data[j]);
      }
      if(i==n-1){
        for(j=0;j<3;j++){ 
          GyroVelocity[j]=nav_data[j];
          GyroPosition[j]+=GyroPositionNewDat[j]-GyroZeroes[j]*n;
        }
      }
      
    }
    //get current rotational velocity for x & y axes
    for(j=0;j<2;j++){
      GyroVelocity[j]=((int32_t)nav_data[j])-GyroZeroes[j];
    }
    AverGyroVelocity/=gn;
    //digitalWrite(Light_Bus_BTN1,1);
    if(gn>=31)
      GyroFifoOverflow=1;
    
    //Get Accelerometer data
    an=AccelBufferSize();
    //if(n>0)
    //digitalWrite(Light_Bus_BTN1,0);
    for(i=0;i<an;i++){
      AccelGetAxes(nav_data);
      //digitalWrite(Light_Bus_BTN1,0);
      /*
      //less efficient but easier to understand:
      for(j=0;j<2;j++){   //just x and y axis
        AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];  
        AccelVelocity[j]+=AccelAcceleration[j];        
        AccelPosition[j]+=AccelVelocity[j]/400;//so in range and same as velocity
      }      
      */
      //more efficient:
      for(j=1;j<2;j++){   //just y axis
        AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];  
        //AccelAcceleration[1]+=(10*(AverGyroVelocity))/8;//assuming that it always rotates about the same point (around where wheels are), experimentally putting this in
        AccelVelocity[j]+=AccelAcceleration[j];        
        AccelPositionNewDat[j]+=AccelVelocity[j];//so in range and same as velocity
      }
      if(i==an-1){
        for(j=1;j<2;j++){//just y axis
          AccelPosition[j]+=AccelPositionNewDat[j]/400;
        }
      }      
      /*
      //better but not debugged yet:
      for(j=0;j<2;j++){   
        AccelVelocityNewDat[j]+=((int32_t)nav_data[j]);
        AccelPositionNewDat[j]+=AccelVelocityNewDat[j];        
      }
      if(i==n-1){
        for(j=0;j<3;j++){ 
          AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];
          AccelPosition[j]=AccelPosition[j]+(AccelVelocity[j]+AccelPositionNewDat[j]*n-AccelZeroes[j]*n)/(400*n);
          AccelVelocity[j]=AccelVelocity[j]+AccelVelocityNewDat[j]-n*AccelZeroes[j];
        }
      }*/

      
      
      //digitalWrite(Light_Bus_BTN1,1);
    }//end for(i=0;i<n;i++
     //get current acceleration for x,y, and z axes
    if(an>0){
      for(j=0;j<3;j++){
        AccelAcceleration[j]=((int32_t)nav_data[j])-AccelZeroes[j];
      }
    }
    //digitalWrite(Light_Bus_BTN1,1);
    if(an>=31)
      AccelFifoOverflow=1;
      
      
  }
  
  
}//end NavigationXY()


void ZeroNavigationSensors(void){
char i,j,n,prev;
  int32_t totals[3];
  //int nav_data[3];//Compiler error:  when nav_data[] local, it was not actually reserving space for this since it isn't explicitly set (is set by pointers)
  prev=PauseNavigationInterrupt;
  PauseNavigationInterrupt=1;//PauseNavigationInterrupt=1;//noInterrupts();
  //Gyro average to find zero value (assuming not currently moving)
  for(i=0;i<3;i++)
    totals[i]=0;
  i=1000;
  while(GyroBufferSize()<20 && i)i--; 
  for(i=0;i<20;i++){
    GyroGetAxes(nav_data);
    for(j=0;j<3;j++){
      totals[j]+=nav_data[j];
    }
  }
  for(i=0;i<3;i++){
    GyroZeroes[i]=totals[i]/20;
  }
  //Accel average to find zero value (assuming not currently moving)
  for(i=0;i<3;i++)
    totals[i]=0;
  i=1000;
  while(AccelBufferSize()<20 && i)i--; 
  for(i=0;i<20;i++){
    AccelGetAxes(nav_data);
    for(j=0;j<3;j++){
      totals[j]+=nav_data[j];
    }
  }
  for(i=0;i<3;i++){
    AccelZeroes[i]=totals[i]/20;
    AccelVelocity[i]=0;//assumes it isn't moving when this function called
  }  
  //Clear buffers
  n=AccelBufferSize();
  for(i=0;i<n;i++){
    AccelGetAxes(nav_data);
  }
  n=GyroBufferSize();
  for(i=0;i<n;i++){
    GyroGetAxes(nav_data);
  }
  AccelFifoOverflow=0; 
  PauseNavigationInterrupt=prev;//interrupts();//PauseNavigationInterrupt=0;
  for(i=0;i<3;i++){
    AccelVelocity[i]=0;
  } 
}//end ZeroNavigation()

void ZeroNavigation(void){
  char i;
   //Zero total changes in position, velocity, and orientation
  for(i=0;i<3;i++){
    AccelPosition[i]=0;
    AccelVelocity[i]=0;
    GyroPosition[i]=0;
  } 
  
}

void PauseNavigation(void){
  char i;
  PauseNavigationInterrupt=1; 
  for(i=0;i<3;i++){
    AccelVelocity[i]=0;
  }
}
void ResumeNavigation(void){
  char i,n;
  //clear gyro buffer and save last values
  n=GyroBufferSize();
  for(i=0;i<n;i++){
    GyroGetAxes(GyroVelocity);
  }
  //subtract gyro zeroes
  for(i=0;i<3;i++){
   GyroVelocity[i]-=GyroZeroes[i];
  }
  //clear accel buffer and save last values
  n=AccelBufferSize();
  for(i=0;i<n;i++){
   AccelGetAxes(AccelAcceleration);
  }
  //subtract accel zeroes
  for(i=0;i<3;i++){
   AccelAcceleration[i]-=AccelZeroes[i];
  }
  PauseNavigationInterrupt=0;
}

char NavigationPaused(void){
  return PauseNavigationInterrupt;
}

void NavigationBegin(void){//needs I2CBegin();  to be called first
  char i;
  I2CBegin(); 
  PauseNavigationInterrupt=1;
  //
  //GyroWriteRegister(GYR_CTRL_REG3,0x34);//open drain (bit4), watermark interrupt on DRDY/INT2 (bit2). bit5 is INT1 high, but seems to work for INT2 as well
  GyroWriteRegister(GYR_CTRL_REG3,0x30);
  GyroWriteRegister(GYR_FIFO_CTRL_REG,0x54);//watermark FIFO threshold of 20 and fifo stream mode (bits7:6)
  GyroWriteRegister(GYR_CTRL_REG1,0x0f);//all axes on(0:2) and auto-power off disabled
  GyroWriteRegister(GYR_CTRL_REG5,0x40);//fifo enable
  //
  AccelWriteRegister(ACC_CTRL_REG1,0x0);// 0x2a inactive but can set registers (bit1)
  AccelWriteRegister(ACC_CTRL_REG3,0x3);// 0x2c interrupt is OD(bit0), active high(bit1)
  AccelWriteRegister(ACC_CTRL_REG4,0x40);// 0x2d fifo interrupt enable
  //AccelWriteRegister(ACC_CTRL_REG4,0x00);
  AccelWriteRegister(ACC_CTRL_REG5,0x40);// 0x2e fifo interrupt on INT1 pin
  AccelWriteRegister(ACC_F_SETUP,0x14);// 0x9 watermark at 20 measurements
  AccelWriteRegister(ACC_CTRL_REG1,0x9);// 0x2a 400 Hz and active (bit1)
  AccelWriteRegister(ACC_F_SETUP,0x54);// 0x09 circular buffer mode (now at 0x54=01010100)
  //
  
  GyroSetFrequency(380);
  GyroSetRange(2000);
  
  ZeroNavigation();
  
  ZeroNavigationSensors();
  
  pinMode(Accel_Interrupt, INPUT_PULLUP);
  
  NavigationOn=1;
  PauseNavigationInterrupt=0;  
  //
}//end void NavigationBegin(void)



int GetDegrees(void){//for z axis
  return -GyroRawToDegrees(GyroPosition[2]);
}
int GetDegreesPerSecond(void){//for z axis
  return -GyroRawToDegreesPerSec(GyroVelocity[2]);
}
int GetDegreesPerSecondX(void){
  return GyroRawToDegreesPerSec(GyroVelocity[0]);
}
int GetDegreesPerSecondY(void){
  return GyroRawToDegreesPerSec(GyroVelocity[1]);
}
int GetDegreesToStop(void){
  return -GyroDegreesToStopFromRaw(GyroVelocity[2]);
}

int GetAccelerationX(void){
  return ((float)AccelAcceleration[0])*(-(float)(2*9800)/32768);
}
int GetAccelerationY(void){
  return ((float)AccelAcceleration[1])*(-(float)(2*9800)/32768);
}
int GetAccelerationZ(void){
  return ((float)AccelAcceleration[2])*(-(float)(2*9800)/32768);
}
int GetVelocityY(void){
  return ((float)AccelVelocity[1])*(-(float)(2*9800)/32768/400);  
}
int GetPositionY(void){
  return  ((float)AccelPosition[1])*(-(float)(2*9800)/32768/400);//note: already an extra "/400" in handler to keep in range (400 for 400hz)
}
/*int GetPositionX(void){
  return  ((float)AccelPosition[0])*(-(float)(2*9800)/32768/400);//note: already an extra "/400" in handler to keep in range
}*/

//Serial.print(" v= ");Serial.print(-(GetVelocityRaw(1))*(2*9800)/(32768)/400,DEC);
//Serial.print(" p= ");Serial.println(-(GetPositionRaw(1))*(2*9800)/(32768)/400/* /400 in handler instead*/,DEC);
           
void DelayWithNavigation(int ms){
  int32_t total=millis()+ms;
  while(millis()<total){
    SimpleNavigation();
  }
}


// ***************************************************
// end Navigation
// ***************************************************


// ***************************************************
// Accel
// ***************************************************
#include "MMA8451Q.h"
//Note: made refernce to code at
//https://github.com/sparkfun/MMA8452_Accelerometer/tree/master/Firmware
//by Jim Lindblom
#define AccelAddr 0x1C

int32_t AccelPosition[3]={0,0,0};//running total
int32_t AccelVelocity[3]={0,0,0};//running total
int AccelAcceleration[3]={0,0,0};


uint8_t AccelReadRegisters(uint8_t Reg, uint8_t *RxBuffer, uint8_t Length){
  return I2CReadRegs(AccelAddr,0x80|Reg,RxBuffer,Length);//"In order to read multiple bytes, it is necessary to assert the most significant bit of the subaddress field"
}
uint8_t AccelReadRegister(uint8_t Reg){
  return I2CReadReg(AccelAddr,Reg);
}
void AccelWriteRegisters(uint8_t Reg, uint8_t *TxBuffer, uint8_t Length){
   I2CWriteRegs(AccelAddr, Reg, TxBuffer, Length);
}
void AccelWriteRegister(uint8_t Reg, uint8_t TxData){
  I2CWriteReg(AccelAddr, Reg, TxData);
}
//Put in standby to change register settings
void AccelStandby(void){
  byte c = AccelReadRegister(ACC_CTRL_REG1);
  AccelWriteRegister(ACC_CTRL_REG1, c & ~(0x01));
}
//Needs to be in this mode to output data
void AccelActive(void){
  byte c = AccelReadRegister(ACC_CTRL_REG1);
  AccelWriteRegister(ACC_CTRL_REG1, c | 0x01);
}

uint8_t AccelBufferSize(void){
  return AccelReadRegister(ACC_F_STATUS)&0x3F;
}
int AccelGetAxis(char Axis){//Axis=0,1,2 (see p.22)
  uint8_t ar[2];
  int16_t val;//OUT_X_MSB, etc.
  if(Axis>2)
    Axis=2;
  AccelReadRegisters((ACC_OUT_X_MSB+2*Axis),ar,2);
  val=(ar[0]>>2)+(((uint8_t)(ar[1]&0x7F))<<6)+(((uint8_t)(ar[1]&0x80))<<8);
  return val;
}
void AccelGetAxes(int *Axes){//Axis=0,1,2 (see p.22) [int is 16 bit in adruino]
  uint8_t ar[6];
  int i;
  AccelReadRegisters((ACC_OUT_X_MSB),ar,6);
  for(i=0;i<6;i+=2){
     //Axes[i>>1]=(int)(ar[i]>>2)+(((uint8_t)(ar[i+1]&0x7F))<<6)+(((uint8_t)(ar[i+1]&0x80))<<8);
     Axes[i>>1]=(((signed short)ar[i])<<8)+ar[i+1];//((((unsigned int)ar[i])&0x10)<<8)|((((unsigned int)ar[i])&0x7F)<<6);
  }
}



   // Serial.print(" v= ");Serial.print(-(GetVelocityRaw(1))*(2*9800)/(32768)/400,DEC);
   //          Serial.print(" p= ");Serial.println(-(GetPositionRaw(1))*(2*9800)/(32768)/400/* /400 in handler instead*/,DEC);


// ***************************************************
// end Accel
// ***************************************************


// ***************************************************
// Gyro
// ***************************************************
#include "L3GD20.h"
//Note: referenced code from "L3G4200D 3-axis gyro example code" by Jim Lindblom at
//https://www.sparkfun.com/products/10612
//

int32_t GyroPosition[3]={0,0,0};//running total
int GyroVelocity[3]={0,0,0};

#define GyroAddr 0x6B
#define GR_250dps 0x00
#define GR_500dps 0x10
#define GR_2000dps 0x20
int GyroRange=250;//default value for chip
#define GF_95Hz  0b00000000  //wg 20 0f
#define GF_190Hz 0b01000000  //wg 20 4f
#define GF_380Hz 0b10000000  //wg 20 8f
#define GF_760Hz 0b11000000  //wg 20 cf
int GyroFrequency=95;
float GyroRawToDegreesMult=1;
float GyroDegreesToRawMult=1;
float GyroRawToDegreesPerSecMult=1;
float GyroDegreesPerSecToRawMult=1;
float GyroRawToSkidMult=0;
//
uint8_t GyroReadRegisters(uint8_t Reg, uint8_t *RxBuffer, uint8_t Length){
  return I2CReadRegs(GyroAddr,Reg,RxBuffer,Length);
}
uint8_t GyroReadRegister(uint8_t Reg){
  return I2CReadReg(GyroAddr,Reg);
}
void GyroWriteRegisters(uint8_t Reg, uint8_t *TxBuffer, uint8_t Length){
   I2CWriteRegs(GyroAddr, Reg, TxBuffer, Length);
}
void GyroWriteRegister(uint8_t Reg, uint8_t TxData){
  I2CWriteReg(GyroAddr, Reg, TxData);
}


uint8_t GyroBufferSize(void){
  return GyroReadRegister(GYR_FIFO_SRC_REG)&0x1F;
}

int16_t GyroGetAxis(char Axis){//Axis=0,1,2 (p.36)
  int16_t val;//OUT_X_L=0x28, OUT_X_H=0x29 (y and z follow)
  if(Axis>2)
    Axis=2;
  GyroReadRegisters((GYR_OUT_X_L+2*Axis)|0x80,(uint8_t*)val,2);//"In order to read multiple bytes, it is necessary to assert the most significant bit of the subaddressfield."
  return val;
}
void GyroGetAxes(int *Axes){//Axis=0,1,2
  //OUT_X_L=0x28, OUT_X_H=0x29 (y and z follow)
  GyroReadRegisters((GYR_OUT_X_L)|0x80,(uint8_t*)Axes,6);//"In order to read multiple bytes, it is necessary to assert the most significant bit of the subaddressfield."
}

//gyro:
//range	calc dps/dig	"typ" in datasheet	to get to "typ"		
//250	0.007629395	0.00875           	1.14687993         
//500	0.015258789	0.0175           	1.146880005
//2000	0.061035156	0.070            	1.146880005
//Note: 
void UpdateGyroConversionVars(void){
  GyroRawToDegreesPerSecMult=((float)GyroRange)*0.0000355;// 1/2^15=1/32768=0.000030517578125      // 1/2^15*1.14688=exactly .000035
  GyroRawToDegreesMult=GyroRawToDegreesPerSecMult/GyroFrequency;
  GyroDegreesPerSecToRawMult=((float)28169)/GyroRange; //2^15=32768                             //1/0.000035=28571.42857
  GyroDegreesToRawMult=GyroDegreesPerSecToRawMult*GyroFrequency;    
  GyroRawToSkidMult=GyroRawToDegreesPerSecMult*0.1029;//used in GyroDegreesToStopFromRaw()
}
void GyroSetRange(int Range){
  char RangeByte;
  if(Range==2000)
    RangeByte=GR_2000dps;
  else if(Range==500)
    RangeByte=GR_500dps;
  else
    RangeByte=GR_250dps;
  GyroWriteRegister(GYR_CTRL_REG4,RangeByte);
  //FS=250dps: 8.75 mdps/digit
  //   500:    17.5
  //   2000:   70 
  GyroRange=Range;
  UpdateGyroConversionVars();    
}

int GyroGetRangeFromChip(void){
  char d=GyroReadRegister(GYR_CTRL_REG4)&0x30;
  if(d==GR_250dps)
    return 250;
  else if(d==GR_500dps)
    return 500;
  else if(d==GR_2000dps)
    return 2000;
  else 
    return 250;
}

int GyroGetFrequencyFromChip(void){
  char d=GyroReadRegister(GYR_CTRL_REG1)&0xC0;
  if(d==GF_95Hz)
    return 95;
  else if(d==GF_190Hz)
    return 190;
  else if(d==GF_380Hz)
    return 380;
  else if(d==GF_760Hz)
    return 760;  
  else
    return 95;
}

//GyroSetFrequencyByte(GyroReadRegister(GYR_CTRL_REG1)&0xC0);
//              GyroSetRangeByte(GyroReadRegister(GYR_CTRL_REG4)&0x30); 

void GyroSetFrequency(int Frequency){
  char FrequencyByte;
  char r=GyroReadRegister(GYR_CTRL_REG1);  
  if(Frequency==190)
    FrequencyByte=GF_190Hz;
  else if(Frequency==380)
    FrequencyByte=GF_380Hz;
  else if(Frequency==760)
    FrequencyByte=GF_760Hz;
  else if(Frequency==95)
    FrequencyByte=GF_95Hz;
  GyroWriteRegister(GYR_CTRL_REG1,FrequencyByte|(r&~0b11000000));
  GyroFrequency=Frequency;
  UpdateGyroConversionVars();
}

//
int32_t GyroDegreesToRaw(int Degrees){
  int32_t raw=1;
  return GyroDegreesToRawMult*Degrees;
  /*if(GyroRangeByte==GR_250dps){
    raw=-Degrees*100000/875;
    //Serial.print("_250_");
  }
  else if(GyroRangeByte==GR_500dps){
    //Serial.print("_500_");
    raw=-Degrees*10000/175;
  }
  else if(GyroRangeByte==GR_2000dps){
    raw=-Degrees*1000/70;
    //Serial.print("_2000_");
  }
  if(GyroFrequencyByte==GF_95Hz)
    return raw*95;
  else if(GyroFrequencyByte==GF_190Hz)
    return raw*190;
  else if(GyroFrequencyByte==GF_380Hz)
    return raw*380;
  else if(GyroFrequencyByte==GF_760Hz){
    //Serial.print("_760_");
    return raw*760;
  }
  else
    return 0;
  */
}
int GyroDegreesPerSecToRaw(int Degrees){
  return Degrees*GyroDegreesPerSecToRawMult;  
}
int GyroRawToDegrees(int32_t Raw){
  int32_t deg=1;
  return Raw*GyroRawToDegreesMult;
  /*
  if(GyroRangeByte==GR_250dps)
    deg=-Raw*875/100000;
  else if(GyroRangeByte==GR_500dps)
    deg=-Raw*175/10000;
  else if(GyroRangeByte==GR_2000dps){
    deg=-Raw*70/1000;
  }
  if(GyroFrequencyByte==GF_95Hz)
    return deg/95;
  else if(GyroFrequencyByte==GF_190Hz)
    return deg/190;
  else if(GyroFrequencyByte==GF_380Hz)
    return deg/380;
  else if(GyroFrequencyByte==GF_760Hz)
    return deg/760;
  else
    return 0;
  */
}

int GyroRawToDegreesPerSec(int Raw){
  return Raw*GyroRawToDegreesPerSecMult;  
}

int GyroDegreesToStopFromRaw(int DegreesPerSecondRaw){
 int mx=((float)DegreesPerSecondRaw)*GyroRawToSkidMult;
 if(-24<=mx && mx<=24)
   return 0;
 else if(mx>24)
   return mx-24;
 else //mx<24
   return mx+24;
}

int GyroDegreesToStop(int DegreesPerSecond){
  int mx=((float)DegreesPerSecond)*0.1029;
  if(-24<=mx && mx<=24)
   return 0;
 else if(mx>24)
   return mx-24;
 else //mx<24
   return mx+24; 
}



// ***************************************************
// emd Gyro
// ***************************************************













